appModule.controller('PublishCtrl', ["api", "$rootScope", "$scope", "$timeout", 'utils', 'notices', 'pages', 'log', '$translate', '$q', 'native',
 function (api, $rootScope, $scope, $timeout, utils, notices, pages, log, translate, $q, native) {
    $scope.windowName = "publish";
    $scope.summary = "";
    $scope.topicMaxLength = 30;
    $scope.cancelSaveTimeout = null;
    $scope.autoSaveInterval = 60000 * 5;//每隔五分钟自动保存草稿
    $scope.autoSaveMsg = translate.instant("publish.alert.auto-save-draft-success");
    $scope.endTimeText = translate.instant('publish.task.end-time');
    $scope.sendTimeText = translate.instant('publish.task.configuration.send_time');
    $scope.showCloud = notices.hasCloudCapability();
    $scope.showFile = notices.hasDocumentCapability();
    $scope.lang = appModule.lang;
    $scope.defaultTaskTopic = translate.instant('publish.task.topic-placeholder');
    $scope.init = function () {
        var userInfo = native.getUserInfo();
        pages.attachEventScope($scope.windowName + "Window", $scope);
        pages.addWindowCloseListener(function () {
            $scope.onClose(true);
        });
        $scope.isSectionShow = false;
        $scope.coverTaskId = "";
        $scope.currentNotice = notices.notice.create();
        $scope.currentNotice.creatorId = api.getCurrentUser().userId;
        $scope.selectedSections = [];
        $scope.rootorg = [];
        $scope.rootSections = [];
        //群广播发布
        var params = window.location.search;
        $scope.groupId = utils.getUrlParam(params, 'groupId');
        $scope.isCopy = utils.getUrlParam(params, 'isCopy');
        if ($scope.groupId !== null) {
            $scope.groupInfo = notices.getGroupInfo($scope.groupId);
            if ($scope.groupInfo.members && $scope.groupInfo.members.length > 0) {
                $scope.groupInfo.members.forEach(function (member) {
                    notices.getBasicUserInfo(member.userId, $scope.onMemberInfoReceived);
                });
            }
            $scope.selectedSections.push({
                id: $scope.groupId //此数据仅用户校验能否发送广播，不作为真实发布返回。将会在发送前移除
            });
        } else {
            $scope.selectedAccount = notices.retrieveSelectedAccount();
            $scope.initAccount();
        }
        //编辑草稿
        var currentNotice = notices.getTempNotice();

        if (!!currentNotice) {
            var creatorId = $scope.currentNotice.creatorId;
            $scope.setPublisher(creatorId);
            var emptyFn = $scope.currentNotice.isContentEmpty;
            var deferred = $q.defer();
            var promise = deferred.promise;

            if ($scope.isCopy == 1 || (currentNotice.id && !currentNotice.content)) {
                $scope.showLoading = true;
                api.getOneNotice(currentNotice.id, function (data) {
                    $scope.showLoading = false;
                    utils.applyScope($scope, function () {
                        var notice = notices.notice.create();
                        notices.notice.convertFromData(notice, data);
                        currentNotice = $.extend(currentNotice, notice);
                        if (currentNotice.ext_data && currentNotice.ext_data.sub_task_list) {
                            currentNotice.ext_data.sub_list = currentNotice.ext_data.sub_task_list;
                        }
                        if ($scope.isCopy) {
                            currentNotice.topic += translate.instant('publish.copy-title');
                            currentNotice.sections = [];
                            currentNotice.needExpiration = false;
                            delete currentNotice.id;
                            if (currentNotice.ext_data) {
                                currentNotice.ext_data.end_time = null;
                                if (currentNotice.ext_data.sub_list && currentNotice.ext_data.sub_list.length > 0) {
                                    currentNotice.ext_data.sub_list.forEach(function (subTask) {
                                        delete subTask.audit_user_id;
                                        subTask.isEditing = false;
                                    });
                                }
                            }
                            currentNotice.set_timer = null;
                        }
                        if (currentNotice.isEditDisabled) {
                            currentNotice.sections = []; // 转发不显示发布范围
                        }
                        deferred.resolve();
                    });
                }, function (msg) {
                    $scope.showLoading = false;
                    log.logInfo("failed to load notice " + currentNotice.id + "'s detail:" + msg);
                    deferred.resolve();
                });
            } else {
                deferred.resolve();
            }
            promise.then(function () {
                utils.applyScope($scope, function () {
                    if (currentNotice.set_timer) {
                        $scope.delaySendTask = true; //定时发送
                    }
                    $scope.currentNotice = $.extend({}, currentNotice, {
                        isContentEmpty: emptyFn
                    });
                    $scope.currentNotice.isEmbedCover = $scope.currentNotice.isEmbedCover == 1;
                    $scope.selectedSections = currentNotice.sections;
                    $scope.showDefaultSection = !$scope.currentNotice.isEditDisabled;
                    if (!$scope.currentNotice.isEditDisabled) {
                        $scope.autoSave();
                    }
                    if (!!currentNotice.cover) {
                        $scope.coverBackgroundStyle = {
                            "background": "url('" + currentNotice.cover.url + "') no-repeat",
                            "border": "none"
                        };
                    }

                    $scope.summary = currentNotice.summary;

                    $timeout(function () {
                        $scope.$broadcast("ContentReady", $scope.currentNotice.content);
                    });
                });
            });
            notices.deleteTempNotice();
        } else {
            $scope.showDefaultSection = true;
            $scope.autoSave();
            var fileName = location.pathname.substr(location.pathname.lastIndexOf('/') + 1);
            if (fileName == 'task_publish.html') { // 当前界面是任务发布界面
                $scope.currentNotice.category = 'task';
                $scope.currentNotice.needExpiration = false;
                $scope.currentNotice.commentEnabled = false;
                $scope.currentNotice.ext_data = {
                    restriction: {},
                    deny_expired: false
                };
            }
            if ($scope.groupId) {
                $scope.currentNotice.groupId = $scope.groupId;
            }
            $scope.setPublisher($scope.currentNotice.creatorId);
        }
    };

    $scope.setInputEditorCaretPosition = function ($event) {
        utils.setInputEditorCaretPosition($($event.currentTarget));
    };
    $scope.onInputCaretPositionKeyUp = function ($event) {
        utils.onInputCaretPositionKeyUp($($event.currentTarget));
    };

    $scope.setPublisher = function (userId) {
        notices.getBasicUserInfo(userId, function (info) {
            utils.applyScope($scope, function () {
                $scope.publisher = info;
            });
        });
    };

    $scope.initAccount = function () {
        if (!!$scope.selectedAccount) {
            $scope.currentNotice.accountId = $scope.selectedAccount.id;
            $scope.selectedAccount.sectionIDs.forEach(function (val) {
                $scope.rootSections.push({
                    text: val.text, //todo 需要获取当前部门的名称
                    id: val.id
                });
                $scope.rootorg.push(val.id);
            });
        }
    };

    $scope.onMemberInfoReceived = function (info) {
        for (var i = 0; i < $scope.groupInfo.members.length; i++) {
            if (info.userId == $scope.groupInfo.members[i].userId) {
                utils.applyScope($scope, function () {
                    $scope.groupInfo.members[i] = info;
                });

                return;
            }
        }
    };

    $scope.searchGroupMember = function (key, count) {
        key = key.toLowerCase();
        if ($scope.groupInfo && $scope.groupInfo.members.length > 0) {
            var result = $scope.groupInfo.members.filter(function (member) {
                return member.displayName.toLowerCase().indexOf(key) > -1
                    || member.pinyin.toLowerCase().indexOf(key) > -1
                    || member.account.toLowerCase().indexOf(key) > -1
                    || member.position.toLowerCase().indexOf(key) > -1
            });
            if (result && result.length > 0) {
                return result.slice(0, count);
            }
        }
        return [];
    };

    $scope.sectionEquals = function (oldV, newV) {
        if (oldV.sectionIDs.length != newV.sectionIDs.length) {
            return false;
        }
        var result = true, i = 0;
        for (; i < oldV.sectionIDs.length; i++) {
            var index = newV.sectionIDs.findIndex(function (v) {
                return v.id == oldV.sectionIDs[i].id;
            });
            if (index < 0) {
                result = false;
            }
        }
        return result;
    };

    $scope.updateAccount = function (ac) {
        if ($scope.selectedAccount && ac.id == $scope.selectedAccount.id) {
            if ($scope.sectionEquals($scope.selectedAccount, ac)) {
                return;
            }

            $scope.selectedAccount = ac;
            pages.fnCall("contactsgroupWindow", "hideContacts", "", function () {
            });
            utils.applyScope($scope, function () {
                $scope.initAccount();
                api.notifyError(translate.instant("publish.alert.account-update"));
            });
        }
    };

    $scope.editAccount = function (ac) {
        if ($scope.selectedAccount && ac.id == $scope.selectedAccount.id) {
            utils.applyScope($scope, function () {
                $scope.selectedAccount.avatar = ac.avatar;
                $scope.selectedAccount.name = ac.name;
            });
        }
    };

    $scope.onAccountInvalid = function (msg) {
        var option = {
            msg: msg,
            onConfirm: $scope.onClose,
            onCancel: $scope.onClose
        }
        api.notifyError(option);
    };

    $scope.bodyDown = function (e) {
        if (e.keyCode == 8 || e.keyCode == 46) {
            e.stopPropagation();
            $scope.deleteKeyDown(e);
        }
    };

    //自动保存草稿
    $scope.autoSave = function () {
        if ($scope.cancelSaveTimeout) {
            $timeout.cancel($scope.cancelSaveTimeout);
        }
        $scope.cancelSaveTimeout = $timeout(function () {
            if ($scope.isAvailableToSave()) {
                $scope.onSave($scope.autoSave);
            } else {
                $scope.autoSave();
            }
        }, $scope.autoSaveInterval);
    };

    //封面图
    var stopWatch = $scope.$watch("currentNotice.cover", function (newV, oldV) {
        if (!!newV && !!newV.url) {
            if (!oldV || newV.url != oldV.url) {
                $scope.coverBackgroundStyle = {
                    "background": "url('" + newV.url + "') no-repeat",
                    "border": "none"
                };
            }
        }
        else {
            $scope.coverBackgroundStyle = "";
        }
    }, true);

    $scope.toggleCoverOptionDialog = function () {
        $scope.showCoverOptions = !$scope.showCoverOptions;
    };

    $scope.showCoverOptionDialog = function () {
        $scope.showCoverOptions = true;
    };

   

    

    $scope.showUploadImagesPanel = function (callback) {
        $scope.$broadcast('show_upload_panel', {type: 'image', callback: callback});
    };

    //保存广播到草稿箱
    $scope.onSave = function (callback) {
        if ($scope.isAvailableToSave()) {
            if (!!callback) {
                $scope.currentNotice.sections = $scope.selectedSections;
                $scope.currentNotice.summary = $scope.summary;
            }
            if (!!callback || $scope.checkInputs(0)) {
                $scope.currentNotice.createTimestamp = Date.now();
                if ($scope.currentNotice.category == 'task') {
                    $scope.onContentLoaded(null, $scope.currentNotice.content, callback);
                } else if ($scope.currentNotice.category == 'bbs') {
                    $scope.$broadcast("loadContentStart", callback);
                }
            }
        }
    };

    $scope.onContentLoaded = function (e, content, callback) {
        try {
            $scope.currentNotice.content = content;
            if (!$scope.delaySendTask) {
                $scope.currentNotice.set_timer = null;
            }
            notices.saveDraft($scope.currentNotice, function () {
                if (!callback) {
                    $scope.showPublishSuccess(translate.instant("publish.alert.save-draft-success"));
                } else { //自动保存
                    $scope.showPublishSuccess(translate.instant("publish.alert.auto-save-draft-success") + utils.getLocaleDateTime(new Date()), {"background-color": "#4cd964"});
                    callback();
                }
                pages.fnCall("notice", "saveDraft", "", function () {
                });
            });
        } catch (ex) {
            log.logInfo(ex.stack);
            $scope.showPublishSuccess(translate.instant("publish.alert.save-draft-failed"), {"background-color": "#f96868"});
        }
    };

    var offLoadContent = $scope.$on("contentLoaded", $scope.onContentLoaded);

    $scope.onClose = function (saveDraft) {
        if (saveDraft) {
            $scope.onSave(function () {
            });
        }
        $scope.currentNotice = null;
        $scope.$destroy();
        $timeout.cancel($scope.cancelSaveTimeout);
        pages.closeWindow();
    };

    $scope.closePage = function () {
        if (!$scope.currentNotice) {
            $scope.onClose();
        }

        if ($scope.isAvailableToSave()) {
            var option = {
                msg: translate.instant("publish.alert.close-window"),
                onConfirm: $scope.onClose,
                onCancel: null,
                isShowCancel: true
            };
            api.notifyError(option);
        } else {
            $scope.onClose();
        }
    };

    $scope.isAvailableToSendPreview = function () {
        return $scope.currentNotice && $scope.currentNotice.topic && !$scope.currentNotice.isContentEmpty() && $scope.currentNotice.cover;
    };

    $scope.isAvailableToSend = function () {
        return $scope.isAvailableToSendPreview() && $scope.selectedSections.length > 0;
    };

    $scope.isAvailableToSave = function () {
        return $scope.currentNotice && ($scope.currentNotice.topic
            || !$scope.currentNotice.isContentEmpty()
            || $scope.currentNotice.cover
            || $scope.summary
            || $scope.selectedSections.length > 0);
    };

    $scope.toggleCommentEnabled = function () {
        if ($scope.currentNotice) {
            $scope.currentNotice.commentEnabled = !$scope.currentNotice.commentEnabled;
        }
    };

    $scope.onSend = function () {
        if (!$scope.isAvailableToSend() && !$scope.isAvailableToSendTask()) {
            return;
        }
        $scope.currentNotice.type = "";
        if ($scope.checkInputs(1)) {
            var option = {
                msg: translate.instant("publish.alert.send-group-confirm"),
                onConfirm: function () {
                    $scope.showLoading = true;
                    if ($scope.currentNotice.category == 'task') {
                        $scope.onContentUpdate(null, {errorCode: 0, data: $scope.currentNotice.content});
                    } else if ($scope.currentNotice.category == 'bbs') {
                        $scope.$broadcast("onLocalImageStartUpload");
                    } else {
                        $scope.showLoading = false;
                    }
                },
                onCancel: null,
                isShowCancel: true
            };
            api.notifyError(option);
        }
    };

    $scope.onContentUpdate = function (e, args) {
        if (args.errorCode !== 0) {
          //  loglog.logInfo("upload local image failed:" + args.errorMessage);
            $scope.showLoading = false;
            api.notifyError(translate.instant("publish.alert.upload-image-failed"));
            return;
        }
        if ($scope.currentNotice.category == 'task' && !$scope.delaySendTask) {
            $scope.currentNotice.set_timer = null;
        }
        $scope.currentNotice.content = args.data;
        var promise = notices.notice.convertToData($scope.currentNotice);
        promise.then(function (data) {
            if (!data.id && data.type != 'preview') {
                utils.applyScope($scope, function () {
                    notices.saveDraft($scope.currentNotice);
                });
            }
            delete data.id;//删除转发的公告id
            api.sendNotice(data, function (result) {
                utils.applyScope($scope, function () {
                    notices.showGroupNoticeMessage(result);
                        if (result.type == "preview") {
                            utils.applyScope($scope, function () {
                                $scope.isSendingPreview = false;
                                $scope.showLoading = false;
                                $scope.isShowPreviewDialog = false;
                                $scope.sendTo.value = 0;
                                $scope.showPublishSuccess(translate.instant("publish.alert.send-preview-success", {
                                    name: $scope.currentNotice.previewer.name,
                                    category: notices.getCategoryName($scope.currentNotice.category)
                                }));
                            });
                            log.logInfo("success send preview:" + result.id);
                            return;
                        }
                    notices.removeNoticeDraft($scope.currentNotice);
                    pages.fnCall("notice", "sendNotice", result, function () {
                    });
                    $scope.onClose();
                });
            }, function (msg) {
                utils.applyScope($scope, function () {
                    pages.fnCall("notice", "saveDraft", "", function () {
                    });
                    $scope.showLoading = false;
                    $scope.isSendingPreview = false;
                    if (msg) {
                        api.notifyError(msg);
                    } else {
                        api.notifyError(translate.instant("publish.alert.send-failed"));
                    }
                });
            });
        });
    };
    var offImageUploaded = $scope.$on("onLocalImagesUploaded", $scope.onContentUpdate);
    $scope.checkTitleAndContent = function (noAlert) {
        if (!$scope.currentNotice.topic) {
            if (!noAlert) {
                api.notifyError(translate.instant("publish.alert.no-topic"));
            }
            return false;
        }
        if ($scope.currentNotice.isContentEmpty() && $scope.currentNotice.category == 'bbs') {
            if (!noAlert) {
                api.notifyError(translate.instant("publish.alert.no-content"));
            }
            return false;
        }
        return true;
    };
    $scope.convertDefaultSections = function (sections) {
        var tempSections = sections;
        if (tempSections[0] && tempSections.length > 0 && tempSections[0].type == 0) {
            tempSections = tempSections[0].sections;
        }
        return tempSections;
    };
    $scope.checkInputs = function (isSend) {
        var isValid = true;
        $scope.currentNotice.sections = $scope.convertDefaultSections($scope.selectedSections);
        if (!isSend) {
            if (!$scope.currentNotice.topic && $scope.currentNotice.isContentEmpty()) {
                isValid = $scope.checkTitleAndContent();
            }
        } else {
            isValid = $scope.checkTitleAndContent();
            if (!isValid) {
                return isValid;
            }
            if ($scope.currentNotice.sections.length < 1 && isSend == 1) {
                api.notifyError(translate.instant("publish.alert.no-publish-scope"));
                return false;
            }
            if ($scope.currentNotice.category == 'bbs' && (!$scope.currentNotice.cover || !$scope.currentNotice.cover.url)) {
                api.notifyError(translate.instant("publish.alert.no-cover"));
                return false;
            }
            if ($scope.currentNotice.topic.length > $scope.topicMaxLength) {
                api.notifyError(translate.instant("publish.alert.topic-overflow"));
                return false;
            }
            if ($scope.summaryLength > $scope.summaryMaxLength) {
                api.notifyError(translate.instant("publish.alert.summary-overflow"));
                return false;
            }

            if ($scope.currentNotice.category == 'task' && isSend == 1) {
                if ($scope.currentNotice.set_timer && $scope.delaySendTask && $scope.currentNotice.set_timer <= Date.now()) {
                    api.notifyError(translate.instant("publish.alert.larger-delay-send"));
                    return false;
                }
                if ($scope.currentNotice.needExpiration && $scope.currentNotice.ext_data.deny_expired && $scope.currentNotice.set_timer && $scope.delaySendTask && $scope.currentNotice.ext_data.end_time <= $scope.currentNotice.set_timer) {
                    api.notifyError(translate.instant("publish.alert.invalid-delay-send"));
                    return false;
                }
                if ($scope.currentNotice.needExpiration && $scope.currentNotice.ext_data.deny_expired && $scope.currentNotice.ext_data.end_time <= Date.now()) {
                    api.notifyError(translate.instant("publish.alert.invalid-expiration"));
                    return false;
                }
            }
        }
        if (isValid) {
            $scope.currentNotice.summary = $scope.summary;
            return true;
        }

        return isValid;
    };

    $scope.updateCover = function () {
        $scope.isShowCoverPanel = true;
    };

    $scope.closeCover = function () {
        utils.applyScope($scope, function () {
            $scope.isShowCoverPanel = false;
        });
    };

    //检查上传文件的尺寸
    $scope.checkImageSize = function (url, maxWidth, maxHeight, success, error) {
        var img = new Image();
        img.src = url;
        img.onload = function () {
            var width = this.width,
                height = this.height;
            if (width > maxWidth || height > maxHeight) {
                if (error) {
                    error();
                }
            } else {
                if (success) {
                    success();
                }
            }
        };
    };

    $scope.$on("$destroy", function () {
        stopWatch();
        stopWatchSummary();
        offImageUploaded();
        stopWatchSendToValue();
        offLoadContent();
        stopWatchTaskRestriction();
        stopWatchSetTimer();
        pages.detachEventScope($scope.windowName + "Window");
        pages.removeWindowCloseListener();
        $timeout.cancel($scope.cancelSaveTimeout);
    });

    $scope.saveCover = function () {
        var tempCroppedPath = notices.getCropperPath();
        var path = $scope.cropper.crop(tempCroppedPath);
        //         $scope.currentNotice.cover = path;
        $scope.toggleCoverOptionDialog();
        startFileUpload(path);
    };

    $scope.cropper = {};

    $scope.startFileUpload = function (path, callback) {
        var promise = utils.uploadOneFile(path);
        promise.then(function (result) {
            if (result.code === 0) {
                utils.applyScope($scope, function () {
                    $scope.currentNotice.cover = result.data;
                    log.logInfo("upload notice cover:" + result.data.url);
                    callback(0, result.data);
                });
            } else {
                log.logInfo("fail to upload notice cover with error code:" + result.code);
                callback(-1, null);
            }
        });
    };

    $scope.selectNewCover = function (cover, callback) {
        if (cover && cover.url) {
            utils.applyScope($scope, function () {
                var index =  cover.url.indexOf("&cov");
                if(index > -1){
                    cover.url =  cover.url.substring(0,index);
                }
                $scope.currentNotice.cover = cover;
            });

            if (callback) {
                callback();
            }
        }
    };

    $scope.showPublishSuccess = function (msg, style) {
        utils.applyScope($scope, function () {
            $scope.successMsg = msg;
            if (style) {
                $scope.successStyle = style;
            } else {
                $scope.successStyle = null;
            }
            $scope.showSuccessMsg = true;
            $timeout(function () {
                $scope.showSuccessMsg = false;
            }, 3000);
        });

    };

    //-------------------- summary  -----------------------------//
    $scope.summaryMaxLength = 50;
    $scope.summaryLength = 0;
    var stopWatchSummary = $scope.$watch("summary", function (newV, oldV) {
        if (newV && newV.length > 0) {
            $scope.summaryLength = newV.length;
        } else {
            $scope.summaryLength = 0;
        }
    });


    //--------------------- show preview  ----------------//
    $scope.sendTo = {
        value: 0
    };
    $scope.showPreviewDialog = function () {
        if ($scope.currentNotice.category == 'bbs' && !$scope.isAvailableToSendPreview()) {
            return;
        }
        if ($scope.currentNotice.category == 'task' && !$scope.isAvailableToSendPreviewTask()) {
            return;
        }
        $scope.previewReceiver = null;
        $scope.isShowPreviewDialog = true;
    };
    $scope.searchPreviewReceiver = function (isSelected, user) {
        if (user) {
            user.id = "user" + user.id;
            $scope.previewReceiver = user;
            $scope.sendTo.value = 1;
        }
    };

    $scope.sendPreview = function () {
        if (!$scope.previewReceiver && $scope.sendTo.value == 1) {
            return;
        }
        if ($scope.checkInputs(2)) {
            $scope.isSendingPreview = true;
            $scope.currentNotice.type = "preview";
            if ($scope.sendTo.value == 1) {
                $scope.currentNotice.previewer = $scope.previewReceiver;
            } else {
                $scope.currentNotice.previewer = {
                    id: "user" + $scope.publisher.userId,
                    name: $scope.publisher.displayName
                };
            }

            $scope.showLoading = true;

            if ($scope.currentNotice.category == 'task') {
                $scope.onContentUpdate(null, {errorCode: 0, data: $scope.currentNotice.content});
            } else if ($scope.currentNotice.category == 'bbs') {
                $scope.$broadcast("onLocalImageStartUpload");
            } else {
                $scope.showLoading = false;
            }

        }

    }

    $scope.clearPreviewer = function () {
        $scope.previewReceiver = null;
    };

    var stopWatchSendToValue = $scope.$watch("sendTo.value", function (newV) {
        if (newV && newV == 0) {
            $scope.previewReceiver = null;
        }
    });
    //---------------------cloud ------------------//
    $scope.showLoadingUedtior = function () {
        $scope.showLoading = true;
     };

     $scope.hideLoadingUedtior = function () {
        $scope.showLoading = false;
     };
     

    $scope.cloudFileCallback = function (data) {
        pages.setWindowToTop();
        $scope.$broadcast("onCloudFileSelected", data);
    };
    $scope.showCloudFileWindow = function () {
        notices.addCloudFileSelectedEvent({success: $scope.cloudFileCallback, cancel: pages.setWindowToTop});
        notices.openCloudWindow();
    };

    //---------------------search ------------------//
    $scope.setInputWidth = function () {
        var input = event.target;
        input.style.width = '100px';
    };

    //----------------------- task -------------------------//

    api.getFeedIcon('task', function (data) {
        $scope.taskIcon = data;
    }, function (msg) {
        log.logInfo('can\'t not load task icon: ' + msg);
    });
    $scope.isAvailableToSendPreviewTask = function () {
        return $scope.currentNotice && $scope.currentNotice.topic && $scope.currentNotice.topic.length <= $scope.topicMaxLength && $scope.isSelectedRestriction();
    };

    $scope.isSelectedRestriction = function () {
        if ($scope.currentNotice && $scope.currentNotice.ext_data && $scope.currentNotice.ext_data.sub_list && $scope.currentNotice.ext_data.sub_list.length > 0) {
            for (var i = 0; i < $scope.currentNotice.ext_data.sub_list.length; i++) {
                if ($scope.currentNotice.ext_data.sub_list[i].isEditing || !$scope.currentNotice.ext_data.sub_list[i].audit_user_id) {
                    return false;
                }
            }
            return true;
        }
        return false;
    };

    $scope.isAvailableToSendTask = function () {
        return $scope.isAvailableToSendPreviewTask()
            && $scope.selectedSections.length > 0;
    };

    $scope.isAvailableToSaveTask = function () {
        return $scope.currentNotice && ($scope.currentNotice.topic
            || !$scope.currentNotice.isContentEmpty()
            || $scope.isSelectedRestriction()
            || ($scope.currentNotice.ext_data && $scope.currentNotice.ext_data.allow_expired != undefined)
            || $scope.delaySendTask != undefined
            || $scope.selectedSections.length > 0);
    };

    $scope.AddSubTask = function () {
        if (!$scope.currentNotice.ext_data.sub_list) {
            $scope.currentNotice.ext_data.sub_list = [];
        }
        var auditor = null;

        for (var i = 0; i < $scope.selectedAccount.editors.length; i++) {
            if ($scope.currentNotice.creatorId == $scope.selectedAccount.editors[i].id) {
                auditor = $scope.selectedAccount.editors[i];
                break;
            }
        }
        $scope.currentNotice.ext_data.sub_list.push({
            isEditing: true,
            type: 'image',
            restriction: {},
            auditor: auditor
        });
    };

    $scope.deleteSubTask = function (index) {
        var option = {
            msg: translate.instant("publish.alert.delete-current-task"),
            onConfirm: function () {
                $scope.currentNotice.ext_data.sub_list.splice(index, 1);
            },
            onCancel: null,
            isShowCancel: true
        };
        api.notifyError(option);
    };

    $scope.canAddSubTask = function () {
        if (!$scope.currentNotice.ext_data) {
            return false;
        }
        if (!$scope.currentNotice.ext_data.sub_list) {
            return true;
        }
        var index = $scope.currentNotice.ext_data.sub_list.findIndex(function (subTask) {
            return subTask.isEditing == true;
        });
        if (index < 0) {
            return true;
        }

        return false;
    };

    $scope.getExpirationText = function () {
        if ($scope.currentNotice && $scope.currentNotice.ext_data) {
            if (!$scope.currentNotice.needExpiration) {
                return translate.instant('task.detail.no-expired');
            } else if ($scope.currentNotice.ext_data.end_time) {
                return translate.instant('publish.task.task-expiration', {date: utils.time2str($scope.currentNotice.ext_data.end_time / 1000)});
            }
        }
        return "";
    };

    $scope.sortableOptions = {
        handle: ' .move'
    };

    $scope.onTopClick = function($event){
      $scope.$broadcast('onBodyClick',$event.target);
    };

    $scope.init();
    var stopWatchTaskRestriction = $scope.$watch('currentNotice.ext_data.restriction', function (newV, oldV) {
        if (newV && oldV) {
            if (newV.audio && !oldV.audio) {
                newV.file = false;
                return;
            }
            if (newV.file && !oldV.file) {
                newV.audio = false;
            }
        }
    }, true);

    var stopWatchSetTimer = $scope.$watch('currentNotice.set_timer', function (newV, oldV) {
        if (newV && oldV && newV != oldV) {
            $scope.delaySendTask = true;
        }
    });
}]);
